/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IQDConsole;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogViewer
extends JDialog
implements ActionListener,
IQDConsole {
    private static final long serialVersionUID = 1L;
    private JTextArea m_text;
    private boolean m_hideOnClose = true;

    public LogViewer(String title) {
        super((Frame)null, title, false);
        this.createComponents(false);
    }

    public LogViewer(String title, boolean addStop) {
        super((Frame)null, title, false);
        this.createComponents(addStop);
    }

    private void createComponents(boolean addStop) {
        this.setDefaultCloseOperation(2);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout(3, 3));
        Font font = new Font("Monospaced", 0, 10);
        this.m_text = new JTextArea(20, 50);
        this.m_text.setEditable(false);
        this.m_text.setFont(font);
        this.m_text.setTabSize(2);
        this.m_text.setBackground(new Color(96, 0, 0));
        this.m_text.setForeground(Color.WHITE);
        JScrollPane scrollPane = new JScrollPane(this.m_text);
        cp.add((Component)scrollPane, "Center");
        JPanel panel = new JPanel(new FlowLayout());
        JButton b = new JButton("Clear");
        b.setActionCommand("CLEAR");
        b.addActionListener(this);
        panel.add(b);
        if (addStop) {
            b = new JButton("Stop");
            b.setActionCommand("STOP");
            b.addActionListener(this);
            panel.add(b);
        }
        b = new JButton("Close");
        b.setActionCommand("CLOSE");
        b.addActionListener(this);
        panel.add(b);
        cp.add((Component)panel, "North");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setHideOnClose(boolean hide) {
        this.m_hideOnClose = hide;
        if (hide) {
            this.setDefaultCloseOperation(1);
        } else {
            this.setDefaultCloseOperation(3);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("CLEAR")) {
            this.m_text.setText("");
        } else if (e.getActionCommand().equals("CLOSE")) {
            this.OnClose();
        } else if (e.getActionCommand().equals("STOP")) {
            this.OnStop();
        }
    }

    protected void OnStop() {
    }

    protected void OnClose() {
        if (this.m_hideOnClose) {
            this.setVisible(false);
        } else {
            System.exit(0);
        }
    }

    public void println(String message) {
        this.m_text.append(String.valueOf(message) + "\n");
        this.m_text.setCaretPosition(this.m_text.getText().length() - 1);
    }

    public void print(String message) {
        this.m_text.append(message);
        this.m_text.setCaretPosition(this.m_text.getText().length() - 1);
    }
}

